<schema xmlns="http://purl.oclc.org/dsdl/schematron" defaultPhase="alleFehler">
	<ns uri="http://www.schematron.info/arche" prefix="arc"/>
	<phase id="kritischeFehler">
		<active pattern="nutzlast"/>
	</phase>
	<phase id="alleFehler">
		<active pattern="nutzlast"/>
		<active pattern="Repro"/>
		<active pattern="fressSchutz"/>
		<active pattern="vonJedemEinPaar"/>
	</phase>
	<phase id="keineInfos">
		<active pattern="nutzlast"/>
		<active pattern="Repro"/>
		<active pattern="fressSchutz"/>
		<active pattern="vonJedemEinPaar"/>
		<active pattern="gleichberechtigung"/>
	</phase>
	<pattern id="Repro">
		<rule context="arc:tier[@geschlecht='männlich']">
			<report test="number(arc:alter) &gt; number(//arc:maxReproduktionsalter
				/arc:tier_art[arc:name=current()/arc:art]/arc:männlich)" role="error">Das Männchen ist zu alt, Noah! Es wird sich nicht mehr fortpflanzen können. Sorge für die natürliche Auslese.</report>
		</rule>
		<rule context="arc:tier[@geschlecht='weiblich']">
			<report test="number(arc:alter) &gt; 
				number(//arc:maxReproduktionsalter/arc:tier_art
				[arc:name=current()/arc:art]/arc:weiblich)" role="error">Das Weibchen ist zu alt, Noah! Es wird sich nicht mehr fortpflanzen können. Sorge für die natürliche Auslese.</report>
		</rule>
	</pattern>
	<pattern id="nutzlast">
		<rule context="arc:nutzlast">
			<report test="number(//arc:nutzlast) &lt; sum(//arc:gewicht)" role="fatal">Noah, du hast zu viele Tiere an Bord. Die Ladung überschreitet die Nutzlast deiner Arche.</report>
		</rule>
	</pattern>
	<pattern id="fressSchutz">
		<rule context="arc:tier[@fleischfresser='ja']" role="error">
			<report test="parent::*/arc:tier[@fleischfresser='nein']">Es gibt Fleischfresser und Pflanzenfresser in einer Unterkunft. Die Tiere sind keine Nahrungsquelle!</report>
			<report test="parent::*/arc:tier/arc:gewicht &lt; (arc:gewicht div 2)">Noah, dieser Fleischfresser ist zu stark (schwer) für seinen Zimmergenossen. Er könnte ihn als Nahrungsquelle benutzen.</report>
		</rule>
		<rule context="arc:tier">
			<report test="parent::*/arc:tier/arc:gewicht &lt; (arc:gewicht div 10)" role="error">Noah, das Tier ist zu schwer für seine Zimmergenossen! Es könnte einen zertrampeln.</report>
		</rule>
	</pattern>
	<pattern id="vonJedemEinPaar">
		<rule context="arc:tier">
			<report test="count(parent::*/arc:tier[arc:art=current()/arc:art]) 
				&lt; 2">In dieser Unterkunft gibt es weniger als zwei Tiere dieser Art.</report>
			<assert test="count(parent::*/arc:tier[arc:art=current()/arc:art]
				[@geschlecht='männlich'])=1">Ein Paar muss immer (nur) aus einem Männchen und einem Weibchen bestehen.</assert>
		</rule>
	</pattern>
	<pattern id="gleichberechtigung">
		<rule context="arc:tier">
			<report test="count(//arc:tier[arc:art=current()/arc:art]) &gt; 2" role="warn">In der Arche gibt es mehr als zwei Tiere dieser Art.</report>
		</rule>
	</pattern>
	<pattern id="zimmerGemeinschaft">
		<rule context="arc:zimmer">
			<report test="count(arc:tier) &gt; 6" role="info">Noah, bringst du zu viele Tiere in einem Zimmer unter, könnte sich das schlecht auf die Zimmergemeinschaft auswirken! Du solltest nicht mehr als 6 Tiere in einem Zimmer unterbringen.</report>
		</rule>
	</pattern>
</schema>